/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.client.HSCSystemProfileClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class SystemStateChange
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private HSCCECClient hcc;
    private HSCLPARClient hlc;
    private HSCSystemProfileClient hspc;
    private String bootModeStr;
    private String managedSystem;
    private String name;
    private String operation;
    private String profileName;
    private String resourceType;
    private String realUser = System.getProperty("HMCRealUser.name");
    private short backUpType = (short)-1;
    private short bootMode = (short)6;
    private short powerOnMode = (short)-1;
    private String ON_OPERATION = "on";
    private String OFF_OPERATION = "off";
    private String OS_RESET_OPERATION = "osreset";
    private String OS_SHUTDOWN_OPERATION = "osshutdown";
    private String REBUILD_OPERATION = "rebuild";
    private String RECOVERY_OPERATION = "recover";
    private String RESET_OPERATION = "reset";
    private boolean writeStatus;
    private PrintStream output;

    public SystemStateChange(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.hcc = hSCClientObjectFactory.createCECClient(this.name, false);
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            this.hspc = hSCClientObjectFactory.createSystemProfileClient(this.managedSystem, this.name, false);
            if (null == this.hspc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SYSTEM_PROFILE_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE)) {
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.name, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.name == null || this.operation == null || this.resourceType == null) {
            objectArray = new String[]{HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.OPERATION_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", and " + HMCCommandUtils.OPERATION_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE) && this.operation.equals(this.ON_OPERATION) && this.bootMode != HMCCommandUtils.AUTOSTART_PARTITION_MODE && this.powerOnMode == -1) {
            objectArray = new String[]{HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.POWER_ON_MODE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.POWER_ON_MODE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) && this.managedSystem == null) {
            objectArray = new String[]{HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MANAGED_SYSTEM_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE) && this.operation.equals(this.ON_OPERATION) && this.managedSystem == null) {
            objectArray = new String[]{HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MANAGED_SYSTEM_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException {
        block12: {
            String string = null;
            String string2 = null;
            Object[] objectArray = null;
            if (!(this.resourceType == null || this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE) || this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE))) {
                objectArray = new String[]{HMCCommandUtils.PARTITION_TYPE + ", " + HMCCommandUtils.SYSTEM_PROFILE_TYPE + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SYSTEM_TYPE};
                string = "An invalid parameter value was entered. The object type entered must be" + HMCCommandUtils.PARTITION_TYPE + "," + HMCCommandUtils.SYSTEM_PROFILE_TYPE + ", or" + HMCCommandUtils.SYSTEM_TYPE + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_OBJECT_TYPE_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (!(this.operation == null || this.operation.equals(this.ON_OPERATION) || this.operation.equals(this.OFF_OPERATION) || this.operation.equals(this.OS_RESET_OPERATION) || this.operation.equals(this.OS_SHUTDOWN_OPERATION) || this.operation.equals(this.RECOVERY_OPERATION) || this.operation.equals(this.RESET_OPERATION) || this.operation.equals(this.REBUILD_OPERATION))) {
                objectArray = new String[]{this.ON_OPERATION + ", " + this.OFF_OPERATION + ", " + this.OS_RESET_OPERATION + ", " + this.OS_SHUTDOWN_OPERATION + ", " + this.RECOVERY_OPERATION + ", " + this.RESET_OPERATION + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + this.REBUILD_OPERATION};
                string = "An invalid parameter value was entered. The operation entered must be" + this.ON_OPERATION + "," + this.OFF_OPERATION + ", " + this.OS_RESET_OPERATION + ", " + this.OS_SHUTDOWN_OPERATION + ", " + this.RESET_OPERATION + ", and " + this.REBUILD_OPERATION + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_OPERATION_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.powerOnMode != -1 && this.powerOnMode != HMCCommandUtils.FULL_POWER_ON_MODE && this.powerOnMode != HMCCommandUtils.LPAR_POWER_ON_MODE) {
                objectArray = new String[]{HMCCommandUtils.FULL_POWER_ON_MODE + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.LPAR_POWER_ON_MODE};
                string = "An invalid parameter value was entered. The power on mode entered must be" + HMCCommandUtils.FULL_POWER_ON_MODE + " or " + HMCCommandUtils.LPAR_POWER_ON_MODE + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_POWER_ON_MODE_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE) && this.bootMode != 0) {
                if (HMCCommandUtils.FULL_POWER_ON_MODE == this.powerOnMode) {
                    if (this.bootMode != HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE && this.bootMode != HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE && this.bootMode != HMCCommandUtils.NORMAL_BOOT_MODE && this.bootMode != HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE && this.bootMode != HMCCommandUtils.SMS_BOOT_MODE) {
                        objectArray = new String[]{HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SMS_BOOT_MODE_STR};
                        string = "An invalid parameter value was entered. The boot mode entered must be" + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + "," + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", and " + HMCCommandUtils.SMS_BOOT_MODE_STR + ". Please retry command.";
                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_BOOT_MODE_VALUE", string, objectArray);
                        throw new RequiredParameterException(string2);
                    }
                } else if (this.bootMode != HMCCommandUtils.STANDBY_BOOT_MODE && this.bootMode != HMCCommandUtils.AUTOSTART_PARTITION_MODE) {
                    objectArray = new String[]{HMCCommandUtils.STANDBY_BOOT_MODE_STR + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.AUTOSTART_MODE_STR};
                    string = "An invalid parameter value was entered. The boot mode entered must be" + HMCCommandUtils.STANDBY_BOOT_MODE_STR + " or " + HMCCommandUtils.AUTOSTART_MODE_STR + ". Please retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_BOOT_MODE_VALUE", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
            }
            if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) && this.operation.equals(this.ON_OPERATION) && this.bootModeStr != null && this.bootMode != HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE && this.bootMode != HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE && this.bootMode != HMCCommandUtils.NORMAL_BOOT_MODE && this.bootMode != HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE && this.bootMode != HMCCommandUtils.SMS_BOOT_MODE) {
                objectArray = new String[]{HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SMS_BOOT_MODE_STR};
                string = "An invalid parameter value was entered. The boot mode entered must be" + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + "," + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", and " + HMCCommandUtils.SMS_BOOT_MODE_STR + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_BOOT_MODE_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (!this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE) || !this.operation.equals(this.ON_OPERATION)) break block12;
            try {
                Integer n;
                HSCCECClient hSCCECClient = (HSCCECClient)this.hspc.getParentObject();
                Hashtable hashtable = hSCCECClient.getSystemData();
                if (hashtable != null && (n = (Integer)hashtable.get("State")) != null && n != 1) {
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_CEC_NOT_POWERED_ON", "The operation cannot be performed because the managed system is not in the Ready state. Please ensure that the managed system is in the Ready state, then retry the command.", null);
                    throw new RequiredParameterException(string2);
                }
            }
            catch (HSCException hSCException) {
                if (!IDebug.enabled()) break block12;
                hSCException.printStackTrace(this.output);
            }
        }
    }

    private void performSystemOperations() throws HSCException {
        String string = null;
        if (this.operation.equals(this.ON_OPERATION)) {
            this.hcc.powerOn(this.bootMode, this.powerOnMode);
            String[] stringArray = new String[]{this.name};
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("CECBundle", "POWER_ON_SYS_EVENT"), this.realUser, stringArray[0]);
            HSCLogUtils.logSystemEvent((short)2036, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.OFF_OPERATION)) {
            this.hcc.powerOff();
            String[] stringArray = new String[]{this.name};
            string = MessageFormat.format(HSCResourceBundleUtil.getMessage("CECBundle", "POWER_OFF_SYS_EVENT"), this.realUser, stringArray[0]);
            HSCLogUtils.logSystemEvent((short)2038, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.REBUILD_OPERATION)) {
            this.hcc.rebuild();
        } else if (this.operation.equals(this.RESET_OPERATION)) {
            this.hcc.reset();
            String[] stringArray = new String[]{HSCResourceBundleUtil.getMessage("LPARBundle", "SOFT_OS_RESET", "Soft OS"), "FullSystemPartition", this.name};
            string = stringArray[0] + " reset has been executed on FullSystemPartition " + " of CEC " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2012, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.RECOVERY_OPERATION)) {
            this.hcc.partitionDataRecover((short)1);
        }
    }

    private void performPartitionOperations() throws HSCException {
        String string = null;
        String[] stringArray = new String[3];
        if (this.operation.equals(this.ON_OPERATION)) {
            if (null != this.bootModeStr) {
                this.hlc.powerOn(this.profileName, this.bootMode);
            } else {
                this.hlc.powerOn(this.profileName);
            }
            String string2 = HSCResourceBundleUtil.getMessage("ProfileBundle", "DEFAULT_PROFILE", "Default Profile");
            if (this.profileName != null) {
                string2 = this.profileName;
            }
            stringArray = new String[4];
            stringArray[0] = this.hlc.getUserDefinedName();
            String string3 = this.hlc.getIntName();
            stringArray[1] = string3.substring(0, 3);
            stringArray[2] = this.managedSystem;
            stringArray[3] = string2;
            string = "Logical Partition " + stringArray[0] + " with ID  " + stringArray[1] + " of CEC " + stringArray[2] + " has been activated with profile " + stringArray[3];
            HSCLogUtils.logSystemEvent((short)2016, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.OFF_OPERATION)) {
            this.hlc.powerOff();
            stringArray[0] = HSCResourceBundleUtil.getMessage("LPARBundle", "HARD_OS_RESET", "Hard OS");
            stringArray[1] = this.hlc.getUserDefinedName();
            stringArray[2] = this.managedSystem;
            string = stringArray[0] + " reset has been executed on " + stringArray[1] + " of CEC " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2012, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.OS_RESET_OPERATION)) {
            this.hlc.shutdownOS(new Boolean(true), new Boolean(true));
            stringArray[0] = "Shutdown -Fr";
            stringArray[1] = this.hlc.getUserDefinedName();
            String string4 = this.hlc.getIntName();
            stringArray[2] = this.managedSystem;
            string = stringArray[0] + " completed on Operating System of logical partition " + stringArray[1] + " in managed system " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2099, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.OS_SHUTDOWN_OPERATION)) {
            this.hlc.shutdownOS(new Boolean(false), new Boolean(false));
            stringArray[0] = "Shutdown";
            stringArray[1] = this.hlc.getUserDefinedName();
            String string5 = this.hlc.getIntName();
            stringArray[2] = this.managedSystem;
            string = stringArray[0] + " completed on Operating System of logical partition " + stringArray[1] + " in managed system " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2099, string, stringArray, this.realUser);
        } else if (this.operation.equals(this.RESET_OPERATION)) {
            this.hlc.reset(this.profileName);
            stringArray[0] = HSCResourceBundleUtil.getMessage("LPARBundle", "SOFT_OS_RESET", "Soft OS");
            stringArray[1] = this.hlc.getUserDefinedName();
            stringArray[2] = this.managedSystem;
            string = stringArray[0] + " reset has been executed on " + stringArray[1] + " of CEC " + stringArray[2];
            HSCLogUtils.logSystemEvent((short)2012, string, stringArray, this.realUser);
        }
    }

    private void performSystemProfileOperations() throws HSCException {
        if (this.operation.equals(this.ON_OPERATION)) {
            this.hspc.activate();
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.performSystemOperations();
        } else if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE)) {
            this.performPartitionOperations();
        } else if (this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            this.performSystemProfileOperations();
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.name = (String)hashMap.get(HMCCommandUtils.NAME_PARAM);
        this.profileName = (String)hashMap.get(HMCCommandUtils.PROFILE_NAME_PARAM);
        this.operation = (String)hashMap.get(HMCCommandUtils.OPERATION_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.bootModeStr = (String)hashMap.get(HMCCommandUtils.BOOT_MODE_PARAM);
        String string = (String)hashMap.get(HMCCommandUtils.POWER_ON_MODE_PARAM);
        if (string != null) {
            if (string.equals(HMCCommandUtils.FULL_POWER_ON_MODE_STR)) {
                this.powerOnMode = HMCCommandUtils.FULL_POWER_ON_MODE;
            }
            if (string.equals(HMCCommandUtils.LPAR_POWER_ON_MODE_STR)) {
                this.powerOnMode = HMCCommandUtils.LPAR_POWER_ON_MODE;
            }
        } else if (this.bootModeStr != null && this.bootModeStr.equals(HMCCommandUtils.AUTOSTART_MODE_STR)) {
            this.powerOnMode = HMCCommandUtils.LPAR_POWER_ON_MODE;
        }
        if (this.bootModeStr != null) {
            this.bootMode = this.bootModeStr.equals(HMCCommandUtils.NORMAL_BOOT_MODE_STR) ? HMCCommandUtils.NORMAL_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.SMS_BOOT_MODE_STR) ? HMCCommandUtils.SMS_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR) ? HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.STANDBY_BOOT_MODE_STR) ? HMCCommandUtils.STANDBY_BOOT_MODE : (this.bootModeStr.equals(HMCCommandUtils.AUTOSTART_MODE_STR) ? HMCCommandUtils.AUTOSTART_PARTITION_MODE : (short)-1))))));
        } else if (string != null) {
            if (string.equals(HMCCommandUtils.FULL_POWER_ON_MODE_STR)) {
                this.bootMode = HMCCommandUtils.NORMAL_BOOT_MODE;
            }
            if (string.equals(HMCCommandUtils.LPAR_POWER_ON_MODE_STR)) {
                this.bootMode = HMCCommandUtils.STANDBY_BOOT_MODE;
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CHANGE_SYSTEM_STATE_HELP"));
    }

    public static void main(String[] stringArray) {
        SystemStateChange systemStateChange = new SystemStateChange(true);
        System.exit(systemStateChange.process(stringArray));
    }

    public static int oldCommandMain(String[] stringArray) {
        SystemStateChange systemStateChange = new SystemStateChange(true);
        if (systemStateChange.process(stringArray) != 0) {
            System.exit(1);
        }
        return 0;
    }

    public static void entryMethod(String[] stringArray) {
        SystemStateChange systemStateChange = new SystemStateChange(false);
        systemStateChange.process(stringArray);
    }

    public int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                hSCException.printStackTrace(this.output);
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace(this.output);
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                exception.printStackTrace(this.output);
            }
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

